==========================
# Django Custom User Model App + Django Allauth
==========================

Django custom user model app integrated with Django Allauth
Integrated set of Django applications addressing authentication,
registration, account management as well as 3rd party (social) account
authentication.

Home page
  https://www.ghorz.com/blog/Apps/2020-03-20/21/django-custom-user-model-app-and-django-allauth/


FEATURES
=========

+ Custom User Model
   - Fields
   - email
   - first_name
   - last_name
   - middle_name
   - photo - ImageField

  NOTE: username field is not included.

+ Methods
  - get_full_name() - return first_name, middle_name and last_name
  - get_short_name() - returns first_name and last_name
  - get_user_profile() - returns JSON data
comprising

```python
      {
      'email': self.email,
      'first_name': self.first_name,
      'last_name': self.last_name,
      'middle_name': self.middle_name,
      'photo': self.photo,
      'is_active': self.is_active,
      'is_staff': self.is_staff,
      'is_superuser': self.is_superuser,
      'last_login': self.last_login,
      'date_joined': self.date_joined,
      'full_name': self.get_full_name(),
      'short_name': self.get_short_name(),
      }
```

- Django Allauth
Used for authentication.

- Bootstrap templates for DJANGO ALLAUTH
    https://bootsnipp.com/snippets/d2eZ

## REQUIRED APPS
  - pip install django-allauth
  - pip install Django>=2.2
  - pip install django-bootstrap4

 ## INSTALLATION
 ==================
```python
 settings.py
 #BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
 TEMPLATES_DIR = os.path.join(BASE_DIR, 'templates')
 MEDIA_DIR = os.path.join(BASE_DIR, 'media')
 STATIC_DIR = os.path.join(BASE_DIR, 'static')


 INSTALLED_APPS = [
     'django.contrib.admin',
     'django.contrib.auth',
     'django.contrib.contenttypes',
     'django.contrib.sessions',
     'django.contrib.messages',
     'django.contrib.staticfiles',
     'django.contrib.sites', # external

     # THIRD PARTY
     'bootstrap4',

     # DANGO ALLAUTH
     'allauth',
     'allauth.account',
     'allauth.socialaccount',

     # USER APP
     'user_app',
 ]
 SITE_ID = 1


 TEMPLATES = [
     {
         'BACKEND': 'django.template.backends.django.DjangoTemplates',
         'DIRS': [TEMPLATES_DIR,], ## for template dir
         'APP_DIRS': True,
         'OPTIONS': {
             'context_processors': [
                 'django.template.context_processors.debug',
                 'django.template.context_processors.request',
                 'django.contrib.auth.context_processors.auth',
                 'django.contrib.messages.context_processors.messages',
             ],
         },
     },
 ]


 #STATIC_URL = '/static/'
 MEDIA_ROOT = MEDIA_DIR
 MEDIA_URL = '/media/'
 STATICFILES_DIRS = [STATIC_DIR,]

 #Email Settings
 EMAIL_USE_TLS = True
 EMAIL_HOST = 'smtp.gmail.com'
 EMAIL_HOST_USER = 'youremail@gmail.com'
 EMAIL_HOST_PASSWORD = 'your email password'
 EMAIL_PORT = 587

 # IMPORT USER_APP SETTINGS
 from user_app.settings import *
```

urls.py
```python
path('accounts/', include('allauth.urls')),
```

WARNING: THIS SHOULD BE YOUR FIRST MIGRATION
python manage.py makemigrations user_app
python manage.py migrate

## License
[MIT](https://choosealicense.com/licenses/mit/)

## Donate
# ==================
BITCOIN: 389rzApDvz3TsKLjjTQBP9UPXM87SPD5aH
